//Dustin Soodak




//Bump detection with gyroscope
#include "Navigation.h"
#include "MiscHardware.h"//for simple timer functions RestartTimer() & GetTime()
void setup(){
  Serial.begin(38400);
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  NavigationBegin();//initialize and start navigation
  RestartTimer();  
}
int PrintDelay=200;
int BumpLevel=10;
int PrintBump=0;
int dpsX,dpsY,dpsZ;//to store degrees and degress per second
void loop(){
  SimpleGyroNavigation();  
  dpsX=GetDegreesPerSecondX();
  dpsY=GetDegreesPerSecondY();
  dpsZ=GetDegreesPerSecondZ();
  if(abs(dpsX)>BumpLevel || abs(dpsY)>BumpLevel  || abs(dpsZ)>BumpLevel)
    PrintBump=1;
  if(GetTime()>PrintDelay || PrintBump){
    if(GyroFifoOverflow)//happens if SimpleGyroNavigation() not called often enough
      Serial.print("overflow ");
    Serial.print("dpsX: ");
    Serial.print(dpsX,DEC);
    Serial.print(", dpsY: ");
    Serial.print(dpsY,DEC);
    Serial.print(", dpsZ: ");
    Serial.print(dpsZ,DEC);
    if(PrintBump){
      Serial.print(" bumped! ");      
    }
    Serial.println();
    PrintBump=0;
    RestartTimer(); 
  }
}



